<?php
// bot.php

// 1. Basic Configuration
$token = "YOUR_BOT_TOKEN";
$apiURL = "https://api.telegram.org/bot$token/";

// 2. Get Update (message or callback)
$update = json_decode(file_get_contents("php://input"), true);

// 3. Handle Standard Message
if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $text = $update["message"]["text"] ?? "";

    switch ($text) {
        case "/start":
            sendMessage($chatId, "👋 Welcome to our bot!\nClick the buttons below or type a command.");
            sendLinkButton($chatId, "🌐 Explore Options:");
            break;

        case "/image":
            sendPhoto($chatId, "https://placekitten.com/400/300", "🐱 Here’s a cute kitten for you!");
            break;

        case "/doc":
            sendDocument($chatId, "https://www.w3.org/WAI/ER/tests/xhtml/testfiles/resources/pdf/dummy.pdf", "📄 Sample PDF");
            break;

        case "/popup":
            sendInlineKeyboard($chatId, "Click below to see a pop-up!");
            break;

        default:
            sendMessage($chatId, "❓ Unknown command. Try /start, /image, /doc or /popup.");
    }
}

// 4. Handle Inline Keyboard Callback
if (isset($update["callback_query"])) {
    $callbackId = $update["callback_query"]["id"];
    $callbackData = $update["callback_query"]["data"];
    $chatId = $update["callback_query"]["message"]["chat"]["id"];

    if ($callbackData === "show_popup") {
        answerCallbackQuery($callbackId, "✅ This is a popup alert!", true);
    }
}

// 5. Handle New User Join (before /start)
if (isset($update["my_chat_member"])) {
    $chatId = $update["my_chat_member"]["chat"]["id"];
    $status = $update["my_chat_member"]["new_chat_member"]["status"];

    if ($status === "member") {
        sendMessage($chatId, "👋 Welcome! Type /start to begin.");
    }
}

// =======================
// === Helper Functions ===
// =======================

function sendMessage($chatId, $text)
{
    global $apiURL;
    $url = $apiURL . "sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => "HTML"
    ];
    file_get_contents($url . "?" . http_build_query($data));
}

function sendPhoto($chatId, $photoUrl, $caption = "")
{
    global $apiURL;
    $url = $apiURL . "sendPhoto";
    $data = [
        'chat_id' => $chatId,
        'photo' => $photoUrl,
        'caption' => $caption
    ];
    file_get_contents($url . "?" . http_build_query($data));
}

function sendDocument($chatId, $docUrl, $caption = "")
{
    global $apiURL;
    $url = $apiURL . "sendDocument";
    $data = [
        'chat_id' => $chatId,
        'document' => $docUrl,
        'caption' => $caption
    ];
    file_get_contents($url . "?" . http_build_query($data));
}

function sendInlineKeyboard($chatId, $text)
{
    global $apiURL;
    $keyboard = [
        "inline_keyboard" => [
            [["text" => "Show Pop-up", "callback_data" => "show_popup"]]
        ]
    ];
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'reply_markup' => json_encode($keyboard)
    ];
    file_get_contents($apiURL . "sendMessage?" . http_build_query($data));
}

function sendLinkButton($chatId, $text)
{
    global $apiURL;
    $keyboard = [
        "inline_keyboard" => [
            [["text" => "🌍 Visit Site", "url" => "https://example.com"]],
            [["text" => "📄 View PDF", "url" => "https://www.w3.org/WAI/ER/tests/xhtml/testfiles/resources/pdf/dummy.pdf"]]
        ]
    ];
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'reply_markup' => json_encode($keyboard)
    ];
    file_get_contents($apiURL . "sendMessage?" . http_build_query($data));
}

function answerCallbackQuery($callbackId, $text, $showAlert = false)
{
    global $apiURL;
    $data = [
        'callback_query_id' => $callbackId,
        'text' => $text,
        'show_alert' => $showAlert
    ];
    file_get_contents($apiURL . "answerCallbackQuery?" . http_build_query($data));
}
?>
